VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Object = "{67397AA1-7FB1-11D0-B148-00A0C922E820}#6.0#0"; "MSADODC.OCX"
Object = "{CDE57A40-8B86-11D0-B3C6-00A0C90AEA82}#1.0#0"; "MSDATGRD.OCX"
Begin VB.Form frmPlaybackParameters 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Playback Parameters"
   ClientHeight    =   3660
   ClientLeft      =   150
   ClientTop       =   720
   ClientWidth     =   8715
   Icon            =   "PlaybackParamters.frx":0000
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   ScaleHeight     =   3660
   ScaleWidth      =   8715
   StartUpPosition =   3  'Windows Default
   Begin MSAdodcLib.Adodc Adodc1 
      Height          =   312
      Left            =   7560
      Top             =   120
      Visible         =   0   'False
      Width           =   972
      _ExtentX        =   2117
      _ExtentY        =   582
      ConnectMode     =   0
      CursorLocation  =   3
      IsolationLevel  =   -1
      ConnectionTimeout=   15
      CommandTimeout  =   30
      CursorType      =   3
      LockType        =   3
      CommandType     =   8
      CursorOptions   =   0
      CacheSize       =   50
      MaxRecords      =   0
      BOFAction       =   0
      EOFAction       =   0
      ConnectStringType=   1
      Appearance      =   1
      BackColor       =   -2147483643
      ForeColor       =   -2147483640
      Orientation     =   0
      Enabled         =   0
      Connect         =   "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=d:\SciFish2000\data\pingData.mdb;Persist Security Info=False"
      OLEDBString     =   "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=d:\SciFish2000\data\pingData.mdb;Persist Security Info=False"
      OLEDBFile       =   ""
      DataSourceName  =   ""
      OtherAttributes =   ""
      UserName        =   ""
      Password        =   ""
      RecordSource    =   $"PlaybackParamters.frx":030A
      Caption         =   "Adodc1"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      _Version        =   393216
   End
   Begin VB.Frame Frame1 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1368
      Left            =   36
      TabIndex        =   8
      Top             =   0
      Width           =   6168
      Begin VB.Label lblPingSeries 
         BorderStyle     =   1  'Fixed Single
         Caption         =   "No current ping series."
         Height          =   300
         Left            =   120
         TabIndex        =   11
         Top             =   384
         Width           =   5940
      End
      Begin VB.Label lblDB 
         BorderStyle     =   1  'Fixed Single
         Caption         =   "No current ping series."
         Height          =   288
         Left            =   120
         TabIndex        =   9
         Top             =   960
         Width           =   5940
      End
      Begin VB.Label Label3 
         Caption         =   "Database"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   228
         Index           =   1
         Left            =   120
         TabIndex        =   13
         Top             =   780
         Width           =   2196
      End
      Begin VB.Label Label3 
         Caption         =   "Ping Series"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   228
         Index           =   0
         Left            =   120
         TabIndex        =   12
         Top             =   180
         Width           =   2196
      End
   End
   Begin MSComDlg.CommonDialog CommonDialog1 
      Left            =   3000
      Top             =   60
      _ExtentX        =   688
      _ExtentY        =   688
      _Version        =   393216
   End
   Begin VB.Frame Frame2 
      Caption         =   "Playback Mode"
      Height          =   1368
      Left            =   6264
      TabIndex        =   0
      Top             =   0
      Width           =   2385
      Begin VB.CheckBox chkLoop 
         Caption         =   "&Loop Playback"
         Height          =   225
         Left            =   132
         TabIndex        =   10
         Top             =   1080
         Value           =   1  'Checked
         Visible         =   0   'False
         Width           =   1365
      End
      Begin VB.TextBox txtInterval 
         Alignment       =   2  'Center
         Height          =   285
         Left            =   1020
         TabIndex        =   3
         Text            =   "1"
         Top             =   720
         Width           =   555
      End
      Begin VB.OptionButton optAuto 
         Caption         =   "&Automatically"
         Height          =   195
         Left            =   90
         TabIndex        =   2
         Top             =   480
         Width           =   1395
      End
      Begin VB.OptionButton optManual 
         Caption         =   "&Manual"
         Height          =   195
         Left            =   90
         TabIndex        =   1
         Top             =   240
         Value           =   -1  'True
         Width           =   945
      End
      Begin VB.Label Label2 
         AutoSize        =   -1  'True
         Caption         =   "seconds"
         Height          =   195
         Left            =   1650
         TabIndex        =   5
         Top             =   750
         Width           =   600
      End
      Begin VB.Label Label1 
         AutoSize        =   -1  'True
         Caption         =   "Every"
         Height          =   195
         Left            =   510
         TabIndex        =   4
         Top             =   750
         Width           =   405
      End
   End
   Begin VB.Frame Frame3 
      Caption         =   "Ping Series Browser"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   2124
      Left            =   48
      TabIndex        =   6
      Top             =   1500
      Width           =   8592
      Begin MSDataGridLib.DataGrid DataGrid1 
         Bindings        =   "PlaybackParamters.frx":037D
         Height          =   1800
         Left            =   120
         TabIndex        =   7
         Top             =   240
         Width           =   8376
         _ExtentX        =   14764
         _ExtentY        =   3175
         _Version        =   393216
         AllowUpdate     =   0   'False
         HeadLines       =   1
         RowHeight       =   15
         FormatLocked    =   -1  'True
         BeginProperty HeadFont {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ColumnCount     =   7
         BeginProperty Column00 
            DataField       =   "name"
            Caption         =   "name"
            BeginProperty DataFormat {6D835690-900B-11D0-9484-00A0C91110ED} 
               Type            =   0
               Format          =   ""
               HaveTrueFalseNull=   0
               FirstDayOfWeek  =   0
               FirstWeekOfYear =   0
               LCID            =   1033
               SubFormatType   =   0
            EndProperty
         EndProperty
         BeginProperty Column01 
            DataField       =   "starttime"
            Caption         =   "starttime"
            BeginProperty DataFormat {6D835690-900B-11D0-9484-00A0C91110ED} 
               Type            =   0
               Format          =   ""
               HaveTrueFalseNull=   0
               FirstDayOfWeek  =   0
               FirstWeekOfYear =   0
               LCID            =   1033
               SubFormatType   =   0
            EndProperty
         EndProperty
         BeginProperty Column02 
            DataField       =   "stoptime"
            Caption         =   "stoptime"
            BeginProperty DataFormat {6D835690-900B-11D0-9484-00A0C91110ED} 
               Type            =   0
               Format          =   ""
               HaveTrueFalseNull=   0
               FirstDayOfWeek  =   0
               FirstWeekOfYear =   0
               LCID            =   1033
               SubFormatType   =   0
            EndProperty
         EndProperty
         BeginProperty Column03 
            DataField       =   "nPings"
            Caption         =   "nPings"
            BeginProperty DataFormat {6D835690-900B-11D0-9484-00A0C91110ED} 
               Type            =   0
               Format          =   ""
               HaveTrueFalseNull=   0
               FirstDayOfWeek  =   0
               FirstWeekOfYear =   0
               LCID            =   1033
               SubFormatType   =   0
            EndProperty
         EndProperty
         BeginProperty Column04 
            DataField       =   "notes"
            Caption         =   "notes"
            BeginProperty DataFormat {6D835690-900B-11D0-9484-00A0C91110ED} 
               Type            =   0
               Format          =   ""
               HaveTrueFalseNull=   0
               FirstDayOfWeek  =   0
               FirstWeekOfYear =   0
               LCID            =   1033
               SubFormatType   =   0
            EndProperty
         EndProperty
         BeginProperty Column05 
            DataField       =   "pingSeriesID"
            Caption         =   "pingSeriesID"
            BeginProperty DataFormat {6D835690-900B-11D0-9484-00A0C91110ED} 
               Type            =   0
               Format          =   ""
               HaveTrueFalseNull=   0
               FirstDayOfWeek  =   0
               FirstWeekOfYear =   0
               LCID            =   1033
               SubFormatType   =   0
            EndProperty
         EndProperty
         BeginProperty Column06 
            DataField       =   "speedofsound"
            Caption         =   "speedofsound"
            BeginProperty DataFormat {6D835690-900B-11D0-9484-00A0C91110ED} 
               Type            =   0
               Format          =   ""
               HaveTrueFalseNull=   0
               FirstDayOfWeek  =   0
               FirstWeekOfYear =   0
               LCID            =   1033
               SubFormatType   =   0
            EndProperty
         EndProperty
         SplitCount      =   1
         BeginProperty Split0 
            BeginProperty Column00 
               ColumnWidth     =   1950.236
            EndProperty
            BeginProperty Column01 
               ColumnWidth     =   1950.236
            EndProperty
            BeginProperty Column02 
               ColumnWidth     =   1950.236
            EndProperty
            BeginProperty Column03 
               ColumnWidth     =   1019.906
            EndProperty
            BeginProperty Column04 
               ColumnWidth     =   1950.236
            EndProperty
            BeginProperty Column05 
               ColumnWidth     =   1950.236
            EndProperty
            BeginProperty Column06 
               ColumnWidth     =   1110.047
            EndProperty
         EndProperty
      End
   End
   Begin VB.Menu mnuPlayback 
      Caption         =   "&Playback"
      Begin VB.Menu mnuSelectPingSeries 
         Caption         =   "&Select Ping Series"
      End
      Begin VB.Menu mnuUpdateCounts 
         Caption         =   "&Update Ping Counts"
      End
      Begin VB.Menu mnuPSConfiguration 
         Caption         =   "&View PS Sonar Configuration"
      End
      Begin VB.Menu mnuSpace1 
         Caption         =   "-"
      End
      Begin VB.Menu mnuOpenDatabase 
         Caption         =   "&Open Database"
         Shortcut        =   ^O
      End
      Begin VB.Menu mnuSpace2 
         Caption         =   "-"
      End
      Begin VB.Menu mnuApply 
         Caption         =   "&Apply Parameters"
         Shortcut        =   ^A
      End
      Begin VB.Menu mnuClose 
         Caption         =   "Close &Window"
         Shortcut        =   ^W
      End
   End
   Begin VB.Menu mnuContext 
      Caption         =   "Context"
      Visible         =   0   'False
      Begin VB.Menu mnuSelectPingSeries2 
         Caption         =   "Select Ping Series"
      End
      Begin VB.Menu mnuNotesEdit2 
         Caption         =   "Edit Notes"
      End
      Begin VB.Menu mnuEditName2 
         Caption         =   "Edit Name"
      End
   End
End
Attribute VB_Name = "frmPlaybackParameters"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Const baseQuery As String = _
  "SELECT name, starttime, stoptime,  nPings, notes, pingSeriesID, speedofsound From pingseries "

Private mAborted As Boolean
Private mChangedSinceApply As Boolean
Private mIsReadOnly As Boolean
Private mLoopPlayback As Boolean
Private mManualPlayback As Boolean
Private mPlaybackInterval As Single
Private mPingSeriesCount As Long
Private mPingSeriesID As String
Private mPingSeriesName As String
Private mPingSeriesStart As Date
Private mSortField As String
Private mSortFieldAscending As Boolean
Private mSortFieldSecondary As String
Private mSortFieldSecondaryAscending As Boolean
Private mSpeedOfSound As Single
Private Function Apply() As Boolean

  '  Applies parameters; returns true if cancelled
  
  If mIsReadOnly Then
     MsgBox "Can not update parameters when Pinging!  No changes applied."
     Exit Function
  End If

  On Error GoTo oops
  
  If mPingSeriesID = "" Then
    MsgBox "No ping series is currently selected.", vbOKOnly + vbExclamation, _
           "Apply Parameters"
    Apply = True
    Exit Function
  End If
    
  If optAuto.value Then
    ValidateFloatTextBox txtInterval, 0, 60, 5, "Playback Interval", _
                         mPlaybackInterval, True
  End If
  
  With general.sonarIF
    .SetPingSeriesName mPingSeriesName
    .SetPingSeriesID mPingSeriesID
    .SetPingCount mPingSeriesCount
    .SetPingInterval mPlaybackInterval
    .SetManualPing optManual
    .SetLoopPlayback chkLoop = vbChecked
  End With
  
  With general.propertyList
    .SetProperty "Playback:PingSeriesName", mPingSeriesName
    .SetProperty "Playback:PingSeriesID", mPingSeriesID
    .SetProperty "Playback:PingCount", mPingSeriesCount
    .SetProperty "Playback:PingInterval", mPlaybackInterval
    .SetProperty "Playback:ManualPing", optManual
    .SetProperty "Playback:LoopPlayback", chkLoop = vbChecked
  End With
  
'
'  general.sonarIF.OpenPlaybackFile Adodc1.connectionString, _
'                                   mPingSeriesID, mSpeedOfSound
'  general.sonarIF.OpenPingFile general.dBSourcePrefix & general.pingDB.GetFile, _
'                               mPingSeriesID
  mChangedSinceApply = False
  Apply = False
  Exit Function

oops:

  If Err.number <> utilValidationError Then _
    ErrorBox boxCaption:="Playback Open Failure"
  Apply = True

End Function


Public Sub CountPings()

  On Error GoTo oops

  
  '  Generate a recordset containing pingseries and ping counts
  
  Dim countRS As ADODB.Recordset
  Dim query As String
  Set countRS = New ADODB.Recordset
  query = "select pingseries.pingseriesid, count(pingseries.pingseriesid) as pingCount " & _
          "from ping,pingseries where ping.pingseriesid=pingseries.pingseriesid " & _
          "group by pingseries.pingseriesid"
  Set countRS = general.pingDB.RecordSetOpen(query, options:=adCmdText)
  
  Dim pingseriesRS As ADODB.Recordset
  If Not countRS.EOF Then
  
    ' Use the count recordset to update the pingseries records that
    ' have no ping information.
  
    Set pingseriesRS = general.pingDB.RecordSetOpen("pingseries", options:=adCmdTable)
    
    Do While Not countRS.EOF
      pingseriesRS.MoveFirst
      pingseriesRS.Find "pingseriesid='" & countRS.Fields("pingseriesid") & "'"
      If Not pingseriesRS.EOF Then
        If IsNull(pingseriesRS.Fields("nPings")) Or pingseriesRS.Fields("nPings") <> countRS.Fields("pingCount") Then
          pingseriesRS.Fields("nPings") = countRS.Fields("pingCount")
          pingseriesRS.Update
        End If
      End If
      countRS.MoveNext
    Loop
    
    pingseriesRS.Close
    
  End If
  
  countRS.Close
  Exit Sub
  
oops:

  ErrorBox boxCaption:="Ping Count Update Failed"
  
End Sub
' Turn into function for error reporting - JG
Private Function DataControlConfigure() As Boolean
  ' Add Error handling - JG
  On Error GoTo oops
  DataControlConfigure = True

  Adodc1.connectionString = general.pingDB.GetSource()
  mnuSelectPingSeries.enabled = False
  mnuSelectPingSeries2.enabled = False
  mnuUpdateCounts.enabled = False
  
  If general.pingDB.GetFile = "" Then
    lblDB.caption = "* No database selected!"
    lblDB.backcolor = vbYellow
  ElseIf Not FileExists(general.pingDB.GetFile, writable:=True) Then
    lblDB.caption = "* Database " & general.pingDB.GetFile & " not found or not writable!"
    lblDB.ToolTipText = "* Database " & general.pingDB.GetFile & " not found or not writable!"
    lblDB.backcolor = vbYellow
  Else
    lblDB.caption = general.pingDB.GetFile
    Adodc1.Refresh
    If mPingSeriesID = "" Then
      mPingSeriesID = general.propertyList.GetProperty("Playback:PingSeriesID", "")
      If mPingSeriesID <> "" Then
        Adodc1.Recordset.Find "pingseriesid='" & mPingSeriesID & "'"
        If Not Adodc1.Recordset.EOF Then mnuSelectPingSeries_Click
      Else
        mPingSeriesID = ""
      End If
    End If
    lblDB.backcolor = vbScrollBars
    mnuSelectPingSeries.enabled = Not mIsReadOnly
    mnuSelectPingSeries2.enabled = Not mIsReadOnly
    mnuUpdateCounts.enabled = Not mIsReadOnly
  End If
  ' Error handling - JG
  Exit Function
oops:
  DataControlConfigure = False
  ErrorBox "Couldn't get Playback parameters", "Database may be Corrupted!"
End Function
Public Function GetPlaybackInfo() As Boolean

  Debug.Assert (general.sonarIF.isPlayback)
  
  With general.sonarIF
  
    mIsReadOnly = general.sonarIF.IsPinging
    
    mLoopPlayback = .IsLoopPlayback
    mManualPlayback = .IsManualPing
    mPlaybackInterval = .GetPingInterval()
    mPingSeriesID = .GetPingSeriesID
    mPingSeriesName = .GetPingSeriesName
    'mPingSeriesStart = .getpingSeriesStart
  
  End With
  If mPingSeriesID = "" Then
    lblPingSeries.caption = "* No current ping series"
    lblPingSeries.backcolor = vbYellow
  Else
    lblPingSeries.caption = mPingSeriesName & _
              "; started " '& pingSeriesStart
  End If

  If mLoopPlayback Then
    chkLoop.value = vbChecked
  Else
    chkLoop.value = vbUnchecked
  End If
  
  txtInterval.text = Format(mPlaybackInterval, "0.##")
  
  optManual = mManualPlayback
  optAuto = Not mManualPlayback
  
  optManual.enabled = Not mIsReadOnly
  optAuto.enabled = Not mIsReadOnly
  chkLoop.enabled = Not mIsReadOnly
  
  txtInterval.enabled = Not mIsReadOnly ' JG
  ' txtInterval.Locked = Not mIsReadOnly - JG
  txtInterval.Locked = mIsReadOnly ' JG
  txtInterval.backcolor = IIf(mIsReadOnly, vbMenuBar, vbWindowBackground)
  
  mnuOpenDatabase.enabled = Not mIsReadOnly
  mnuSelectPingSeries.enabled = Not mIsReadOnly
  mnuSelectPingSeries2.enabled = Not mIsReadOnly
  mnuUpdateCounts.enabled = Not mIsReadOnly
  mnuApply.enabled = Not mIsReadOnly
  
  DataControlConfigure
  mChangedSinceApply = False
  
  Me.Show 1

End Function
'Public Function unconfigure(p_pingSeriesID As String, _
'                            p_pingSeriesName As String, _
'                            p_pingSeriesStart As Date, _
'                            p_pingSeriesCount As Long, _
'                            p_loopPlayback As Boolean, _
'                            p_manualPlayback As Boolean, _
'                            p_playbackInterval As Single) As Boolean
'
'  ' Return the information gleaned from the user.
'
'
'  Dim aborted As Boolean
'  If aborted Then
'    unconfigure = False
'  Else
'    unconfigure = True
'    p_pingSeriesID = pingSeriesID
'    p_loopPlayback = chkLoop.value = vbChecked
'    p_playbackInterval = playbackInterval
'    p_manualPlayback = optManual.value
'    p_pingSeriesName = pingSeriesName
'    p_pingSeriesStart = pingSeriesStart
'    p_pingSeriesCount = pingSeriesCount
'
'  End If
'
'End Function

Private Sub Adodc1_Error(ByVal ErrorNumber As Long, description As String, ByVal Scode As Long, ByVal Source As String, ByVal helpFile As String, ByVal HelpContext As Long, fCancelDisplay As Boolean)

  'asdfad
  
  fCancelDisplay = True

End Sub

Private Sub DataGrid1_Click()
  
  If DataGrid1.SelStartCol < 0 Then Exit Sub
  If DataGrid1.SelStartCol >= 4 Then
    Beep
    Exit Sub
  End If
  Dim newSortField As String
  newSortField = DataGrid1.Columns(DataGrid1.SelStartCol).DataField
  If newSortField = mSortField Then ' Same field so toggle direction
    mSortFieldAscending = Not mSortFieldAscending
  Else  ' New field, so make current key the secondary
    mSortFieldSecondary = mSortField
    mSortFieldSecondaryAscending = mSortFieldAscending
    mSortField = newSortField
    mSortFieldAscending = True
  End If
  
  Dim query As String
  query = baseQuery
  query = query & " order by " & mSortField & _
          IIf(mSortFieldAscending, " asc", " desc")
  If mSortFieldSecondary <> "" Then
    query = query & "," & mSortFieldSecondary & _
            IIf(mSortFieldSecondaryAscending, " asc", " desc")
  End If
  
  Adodc1.RecordSource = query
  Adodc1.Refresh

End Sub

Private Sub DataGrid1_DblClick()


  If mIsReadOnly Then
    Beep
    Exit Sub
  End If
  
  mnuSelectPingSeries_Click

End Sub

Private Sub DataGrid1_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)

  If Button = vbRightButton Then
    Me.PopupMenu mnuContext
  End If

End Sub

Private Sub Form_KeyDown(KeyCode As Integer, Shift As Integer)

  Select Case KeyCode
  
    Case vbKeyEscape
      mnuClose_Click
  
  End Select

End Sub

Private Sub Form_Load()

  mSortField = "name"
  mSortFieldAscending = True
  Adodc1.connectionString = "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" + Left(App.Path, 1) + ":\SciFish2000\data\pingData.mdb;Persist Security Info=False" 'DFL
End Sub

Private Sub mnuApply_Click()

  Apply

End Sub

Private Sub mnuClose_Click()

  On Error GoTo oops
  
  If mChangedSinceApply Then
    
    Dim reply As Integer
    reply = MsgBox("Changes have not been applied; apply them?", _
                   vbYesNoCancel + vbQuestion, "Close")
    If reply = vbCancel Then
      Exit Sub
    ElseIf reply = vbYes Then
    
      Dim cancelled As Boolean
      cancelled = Apply()
      If cancelled Then Exit Sub
    
    Else
      ' do nothing
    End If
    
  End If
  
  Unload Me
  Exit Sub
  
oops:

  If Err.number <> utilValidationError Then
    ErrorBox boxCaption:="Close Error"
  End If

End Sub

Private Sub mnuEditName2_Click()

  Dim result As String
  Dim i As Integer
  Dim name As String
  
  On Error GoTo oops
  result = ""
  
  Dim psid As String
  With DataGrid1
    name = .Columns(0).CellText(.RowBookmark(.row))
    psid = .Columns(.Columns.count - 2).CellText(.RowBookmark(.row))
    Dim reply As String
    reply = InputBox("Edit the ping series name", , default:=name)
    If reply <> "" And reply <> name Then
      Dim query As String
      query = "update pingseries set name='" & SqlStrip(reply) & "' where pingseriesid='" & psid & "'"
      general.pingDB.Execute query
      Adodc1.Refresh
    End If
  End With
  Exit Sub
  
oops:

  Beep
  
End Sub

Private Sub mnuNotesEdit2_Click()

  Dim result As String
  Dim i As Integer
  Dim notes As String
  
  On Error GoTo oops
  result = ""
  
  Dim psid As String
  With DataGrid1
    psid = .Columns(.Columns.count - 2).CellText(.RowBookmark(.row))
'    pingSeriesName = .Columns(0).CellText(.RowBookmark(.row))
'    pingSeriesStart = .Columns(1).CellText(.RowBookmark(.row))
'    pingSeriesCount = .Columns(3).CellText(.RowBookmark(.row))
    notes = .Columns(4).CellText(.RowBookmark(.row))
    Load frmNoteEditor
    frmNoteEditor.SetMaxLength 4 * 1024
    frmNoteEditor.SetNotes notes
    frmNoteEditor.Show 1
    If Not frmNoteEditor.IsCancelled Then
      Dim rs As ADODB.Recordset
      Dim query As String
      query = "select notes from pingseries where pingseriesid='" & psid & "'"
      Set rs = general.pingDB.RecordSetOpen(query, options:=adCmdText)
      rs.Fields("notes").AppendChunk frmNoteEditor.GetNotes
      rs.Update
      rs.Close
      Adodc1.Refresh
    End If
    Unload frmNoteEditor
    
  End With
  Exit Sub
  
oops:

  Beep
  

End Sub

Private Sub mnuOpenDatabase_Click()

  Dim newDbFile As String
  
  newDbFile = OpenDB(CommonDialog1, dbPing, False)
  
  If newDbFile = "" Then
  
    ' do nothing
    
  ElseIf Not FileExists(newDbFile, writable:=True) Then
  
    MsgBox "File does not exist or is not writable:" & vbCrLf & vbCrLf & _
           "'" & newDbFile & "'", vbOKOnly + vbExclamation, "Open Database"
  Else

    general.pingDB.dbClose
    general.pingDB.SetFile newDbFile
    general.pingDB.dbOpen
    general.sonarIF.SetPingSeriesID ""
    mPingSeriesID = ""
    lblPingSeries.caption = "* No current ping series"
    lblPingSeries.backcolor = vbYellow
    ' JG - Error handling (Check for corrupt DB)
    If DataControlConfigure() = True Then
        mChangedSinceApply = True
        general.propertyList.SetProperty "General:PingDB", newDbFile
    Else
        general.pingDB.dbClose
   End If
  End If

End Sub

Private Sub mnuPSConfiguration_Click()

  If mPingSeriesID = "" Then
    MsgBox "No ping series is currently selected.", vbOKOnly + vbExclamation, _
           "Cannot View Sonar Configuration"
    Exit Sub
  End If
  
  '  Get the sonar configuration for the current ping series
  
  Dim configuration As SonarConfigurationClass
  Set configuration = New SonarConfigurationClass
  configuration.ReadFromDB general.pingDB, pingSeriesID:=mPingSeriesID
  
  '  Display it using the sonar configuration form
  
  frmSonarConfiguration.Execute True, True, sonarConfiguration:=configuration
  Exit Sub
  
oops:

  ErrorBox boxCaption:="Cannot View Sonar Configuration"

End Sub

Private Sub mnuSelectPingSeries_Click()

  Dim result As String
  Dim i As Integer
  
  On Error GoTo oops
  result = ""
  
  With DataGrid1
    mPingSeriesID = .Columns(.Columns.count - 2).CellText(.RowBookmark(.row))
    mPingSeriesName = .Columns(0).CellText(.RowBookmark(.row))
    mChangedSinceApply = True
    mPingSeriesStart = .Columns(1).CellText(.RowBookmark(.row))
    mPingSeriesCount = .Columns(3).CellText(.RowBookmark(.row))
    lblPingSeries.caption = mPingSeriesName '& "; started " & pingSeriesStart
    If mPingSeriesName = "" Then lblPingSeries.caption = mPingSeriesID
    lblPingSeries.backcolor = vbScrollBars
    mSpeedOfSound = .Columns(.Columns.count - 1).CellText(.RowBookmark(.row))
  End With
  Exit Sub
  
oops:

  Beep

End Sub

Private Sub mnuSelectPingSeries2_Click()

  mnuSelectPingSeries_Click

End Sub

Private Sub mnuUpdateCounts_Click()

  CountPings
  Adodc1.Refresh
  DataGrid1.Refresh

End Sub

Private Sub optAuto_Click()

  If optAuto.value = True And Me.visible Then
    txtInterval.SetFocus
  End If
  mChangedSinceApply = True

End Sub

Private Sub optManual_Click()

  mChangedSinceApply = True

End Sub

Private Sub txtInterval_Change()

  mChangedSinceApply = True
  TextboxColorize txtInterval

End Sub

Private Sub txtInterval_Click()

  optAuto.value = True
  mChangedSinceApply = True

End Sub

Private Sub txtInterval_GotFocus()

  TextboxSelectAll txtInterval

End Sub
